<!--
BOSCH Security Sytems (Ottobrunn)

Project: Magic.Panel

Author: Michael Ziegel

Created: 12.09.2006

$Archive:   //ot1esw2/MagicPanel/PVCS MP-SW/archives/MP_SW/MP_PC_SW/Transformer/Conversion/XSLT/conv-1-0-0-to-1-1-0.xsl-arc  $  

$Revision: 1.26 $ 

Last locked:   $Date: 2015/01/09 09:32:56GMT $

Last change by $Author: Maria Lux (lux2ot) $

History: 
$Log: XSLT/create-net.xsl  $
Revision 1.26 2015/01/09 09:32:56GMT Maria Lux (lux2ot) 
new schema 13.2 supported
Revision 1.25 2014/07/31 11:58:42MESZ Maria Lux (lux2ot) 
changes for IPTI
Revision 1.24 2014/04/14 11:10:30MESZ Maria Lux (lux2ot) 
moved function IsVersionGreaterOrEqual to conv-main.xsl
Revision 1.23 2013/11/29 13:07:37MEZ Maria Lux (lux2ot) 
corrected
Revision 1.22 2013/07/22 13:45:10MESZ Manfred Liegl (lim2grb) 
schema 2.10 considered
Revision 1.21 2013/05/02 11:07:53MESZ Manfred Liegl (lim2grb) 
Extended for Ethernet Rx Overload Warning
Revision 1.20 2012/11/20 15:28:33MEZ Michael Ziegel (zi82ot) 
NODE/usePanelNetworkingOverIP added
Revision 1.19 2012/08/07 14:23:27MESZ Michael Ziegel (zi82ot) 
create CM_SERVER in CONFIG_NETWORK and assignedCMServer in NODE
Revision 1.18 2011/08/12 16:52:22MESZ Michael Ziegel (zi82ot) 
SPANING_TREE above NET_INTERFACES to comply with RPS 2.8.22
Revision 1.17 2011/08/10 14:08:43MESZ Michael Ziegel (zi82ot) 
errors corrected
Revision 1.16 2011/08/10 13:42:07MESZ Michael Ziegel (zi82ot) 
conversion of RSTP-settings
Revision 1.15 2011/03/18 13:21:35MEZ Michael Ziegel (zi82ot) 
Compare version strings numerically
Revision 1.14 2009/02/02 15:47:23MEZ Michael Ziegel (zi82ot) 
Member moved from Conversion/XSLT/create-net.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj to XSLT/create-net.xsl in project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/RPSTools/XMLSupport/XMLSupport.pj.
Revision 1.13 2009/02/02 15:47:23CET Michael Ziegel (zi82ot) 
bypassNACsRange depends on newversion
Revision 1.12 2009/01/22 14:57:19CET Michael Ziegel (zi82ot) 
ASSIGNED_MTSNODES added
Revision 1.11 2009/01/09 09:57:47CET Michael Ziegel (zi82ot) 
repair all siNumber and subNumber without value by setting to 0
Revision 1.10 2008/11/11 12:46:28CET Michael Ziegel (zi82ot) 
bypassNACsRange added to NETWORK_INFO
Revision 1.9 2008/10/06 12:23:33CEST Michael Ziegel (zi82ot) 
revision control added
Revision 1.8 2008/05/29 13:36:09CEST zi82ot 
connectedToLineNumber is 0 by default
Revision 1.7 2008/03/25 14:00:26CET zi82ot 
Missing IMPORT/EXPORTS are now inserted
Revision 1.6 2008/03/13 14:40:22CET zi82ot 
Tidyup conversion. V 2.0.7 supported
Revision 1.5 2007/09/25 09:42:54CEST zi82ot 
added new NOTE/children
Revision 1.4 2007/07/23 10:47:38CEST zi82ot 
new elements (state 2.0.2) of node have to be created
Revision 1.3 2007/03/13 15:18:52CET zi82ot 
copy attributes of modified nodes, create HEADER for LOCAL_CONFIG
Revision 1.2 2007/03/13 11:36:39CET zi82ot 
Attribute rpsLanguage of HEADER is copied
Revision 1.1 2007/03/13 09:58:23CET zi82ot 
Initial revision
Member added to project f:/MKS_Repository/Fire/MagicPanel/Source/PCTools/Transformer/Transformer.pj
Revision 1.3 2006/09/18 12:16:52CEST zi82ot 
-->
<!-- NOTE:
This stylesheet shall perform only the conversions needed to transform from pre-network to network format.
All other transformations e.g from 1.0.0, 1.1.0 1.2.0 to 1.3.0 are performed by including
#### conv-lt-1-3-0-to-1-3-0.xsl ####
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cfg="."   xmlns:user="http://bosch.com">
  <cfg:Stylesheet version="$Revision: 1.26 $"/>
  <xsl:output method="xml" encoding="UTF-8" indent="yes"/>
  <xsl:include href="conv-lt-1-3-0-to-1-3-0.xsl"/>
  <xsl:param name="ConfigFileName" select="''"/>
  <xsl:param name="NetNode" select="'1'"/>
  <xsl:param name="NetGroup" select="'1'"/>
  <xsl:param name="Scope" select="'GROUP'"/>
  <!-- Already included  from conv-lt-1-3-0-to-1-3-0.xsl 
  <xsl:param name="newversion" select="'2.0.0'"/> 
-->
  <!-- ROOT Template 
  -->
  <xsl:template match="/CONFIGURATION">
    <xsl:call-template name="GENERATE_ONE_NODE_NET"/>
  </xsl:template>
  <!-- **************************** generates a configuration as OneNodeNet-configuration *****************
  -->
  <xsl:template name="GENERATE_ONE_NODE_NET">
    <xsl:element name="CONFIG_NETWORK">
      <xsl:element name="HEADER">
        <xsl:element name="filename">
          <xsl:value-of select="$ConfigFileName"/>
        </xsl:element>
        <xsl:element name="revNumber">
          <xsl:value-of select="/CONFIGURATION/HEADER/revNumber"/>
        </xsl:element>
        <xsl:element name="lastModified">
      </xsl:element>
        <xsl:element name="dataVersion">
          <xsl:value-of select="$newversion"/>
        </xsl:element>
        <xsl:call-template name="ExtendHeader"/>
		<xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.10.0')">
			<xsl:element name="xmlValidation">0000</xsl:element>
		</xsl:if>
		<xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.10.0')">
			<xsl:element name="mismatchConfirmed">0</xsl:element>
		</xsl:if>
      </xsl:element>
      <xsl:element name="NETWORK_INFO">
        <xsl:element name="label"/>
        <xsl:element name="note"/>
        <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.1.1')">
          <!--   for all schemas greater or equal 2.1.1  -->
          <xsl:element name="bypassNACsRange">BPR_ALL</xsl:element>
        </xsl:if>
      </xsl:element>
      <xsl:call-template name="CopyCustomerInfo"/>
      <xsl:call-template name="CopySupportInfo"/>
      <xsl:element name="NODES">
        <xsl:element name="netCRC"/>
        <xsl:element name="NODE">
          <xsl:element name="netLocalCRC">0</xsl:element>
          <xsl:element name="netGroup">
            <xsl:value-of select="$NetGroup"/>
          </xsl:element>
          <xsl:element name="netNode">
            <xsl:value-of select="$NetNode"/>
          </xsl:element>
          <xsl:element name="rsn">1</xsl:element>
		  <xsl:choose>
			  <xsl:when test="user:IsVersionGreaterOrEqual($newversion,'2.8.1')">
				<xsl:element name="nodeType">FPA5000-C</xsl:element>
			  </xsl:when>
			  <xsl:otherwise>
				<xsl:element name="nodeType">FPA5000</xsl:element>
			  </xsl:otherwise>
		  </xsl:choose>
          <xsl:element name="scope">
            <xsl:value-of select="$Scope"/>
          </xsl:element>
          <xsl:element name="displayNetworkStates">ST_NO</xsl:element>
          <xsl:element name="label"/>
          <xsl:element name="ipAddress"/>
          <xsl:element name="subnetMask">255.255.255.0</xsl:element>
          <xsl:element name="gateway"/>
          <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.1')">
            <xsl:element name="multicastAddress"/>
            <xsl:element name="portNumber">0</xsl:element>
            <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
              <xsl:element name="useEthernetSettings">ST_NO</xsl:element>
            </xsl:if>
          </xsl:if>
          <xsl:element name="syncRequired">ST_NO</xsl:element>
          <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.9.0')">
            <xsl:element name="assignedCMServer">0</xsl:element>
          </xsl:if>
          <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.9.1')">
            <xsl:element name="usePanelNetworkingOverIP">0</xsl:element>
          </xsl:if>
          <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.9.2')">
            <xsl:element name="showEthernetRxOverloadWarning">ST_YES</xsl:element>
          </xsl:if>
          <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
            <xsl:element name="SPANNING_TREE">
              <xsl:call-template name="InsertSPANNING_TREE"/>
            </xsl:element>
          </xsl:if>
          <xsl:element name="NET_INTERFACES">
            <xsl:element name="NET_INTERFACE">
              <xsl:element name="type">CAN</xsl:element>
              <xsl:element name="interfaceNbr">1</xsl:element>
              <xsl:element name="connectedToNetlineNbr">0</xsl:element>
              <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
                <xsl:element name="isUsed">ST_NO</xsl:element>
              </xsl:if>
              <xsl:call-template name="AddCANParam"/>
            </xsl:element>
            <xsl:element name="NET_INTERFACE">
              <xsl:element name="type">CAN</xsl:element>
              <xsl:element name="interfaceNbr">2</xsl:element>
              <xsl:element name="connectedToNetlineNbr">0</xsl:element>
              <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
                <xsl:element name="isUsed">ST_NO</xsl:element>
              </xsl:if>
              <xsl:call-template name="AddCANParam"/>
            </xsl:element>
            <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.1')">
              <xsl:call-template name="CreateEthernetInterface">
                <xsl:with-param name="InterfaceNumber" select="'1'"/>
              </xsl:call-template>
              <xsl:call-template name="CreateEthernetInterface">
                <xsl:with-param name="InterfaceNumber" select="'2'"/>
              </xsl:call-template>
            </xsl:if>
          </xsl:element>
          <xsl:element name="EXPORTS">
            <xsl:element name="netCRC">0</xsl:element>
            <xsl:element name="REPLICATED_SIS"/>
            <xsl:element name="REPLICATED_COUNTERS"/>
          </xsl:element>
          <xsl:element name="IMPORTS">
            <xsl:element name="netCRC">0</xsl:element>
            <xsl:element name="USED_SIS"/>
            <xsl:element name="USED_COUNTERS"/>
            <xsl:element name="USED_OFFSET_TABLES"/>
          </xsl:element>
          <xsl:element name="ASSIGNED_OPCSVRS"/>
          <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.5.0')">
            <!--   for all schemas greater or equal 2.5.0  -->
            <xsl:element name="ASSIGNED_MTS_NODES"/>
          </xsl:if>
          <xsl:element name="CONFIG_DATA">
            <xsl:element name="LOCAL_CONFIGURATION">
              <xsl:attribute name="panelEncoding"><xsl:value-of select="/CONFIGURATION/@panelEncoding"/></xsl:attribute>
              <xsl:call-template name="CopyLocalConfig"/>
            </xsl:element>
          </xsl:element>
        </xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <xsl:template name="AddP2PData">
	<xsl:element name="REMOTE_SERVICES_NETWORK_DATA">
		<xsl:element name="P2P_DATA">
			<xsl:element name="crl">172.31.31.1</xsl:element>
			<xsl:call-template name="AddCMServer"/>
		</xsl:element>
	</xsl:element>
  </xsl:template>
  <xsl:template name="AddP2PData_CM">
		<xsl:param name="cmNetworkId" select="''"/>
		<xsl:param name="ipAddress" select="''"/>
		<xsl:param name="portNumber" select="'80'"/>
		<xsl:element name="REMOTE_SERVICES_NETWORK_DATA">
			<xsl:element name="P2P_DATA">
			<xsl:element name="crl"/>
			<xsl:call-template name="AddCMServer">
				<xsl:with-param name="cmNetworkId" select="$cmNetworkId"/>
				<xsl:with-param name="ipAddress" select="$ipAddress"/>
				<xsl:with-param name="portNumber" select="$portNumber"/>
			</xsl:call-template>
			</xsl:element>
		</xsl:element>
  </xsl:template>
  <xsl:template name="AddCMServer">
		<xsl:param name="cmNetworkId" select="''"/>
		<xsl:param name="ipAddress" select="''"/>
		<xsl:param name="portNumber" select="'80'"/>
		<xsl:element name="CM_SERVER">
			<xsl:element name="id">1</xsl:element>
			<xsl:element name="cmNetworkId"><xsl:value-of select="$cmNetworkId"/></xsl:element>
			<xsl:element name="ipAddress"><xsl:value-of select="$ipAddress"/></xsl:element>
			<xsl:element name="portNumber"><xsl:value-of select="$portNumber"/></xsl:element>
		</xsl:element>
  </xsl:template>
  <xsl:template name="AddCloudData">
    <xsl:element name="CLOUD_DATA">
      <xsl:element name="ipAddress">172.29.1.1</xsl:element>
      <xsl:element name="portNumber">0</xsl:element>
      <!--xsl:element name="siteName"><xsl:value-of select="$ConfigFileName"/></xsl:element-->
      <xsl:variable name="myName" select="//CONFIG_NETWORK/HEADER/filename"/>
      <xsl:element name="siteName"><xsl:value-of select="user:CutXmlExt(string($myName))"/></xsl:element>
			<xsl:element name="crl">172.31.31.1</xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- insert SPANNING_TREE V 2.8.2
  -->
  <xsl:template name="InsertSPANNING_TREE">
    <xsl:element name="redundancyMode">OFF</xsl:element>
    <xsl:element name="STP_BridgePriority">32768</xsl:element>
    <xsl:element name="STP_HelloTime">2</xsl:element>
    <xsl:element name="STP_MaxAge">20</xsl:element>
    <xsl:element name="STP_ForwardDelay">15</xsl:element>
  </xsl:template>
  <!--  Create Ethernet Interface V 2.8.2
      -->
  <xsl:template name="CreateEthernetInterface">
    <xsl:param name="InterfaceNumber"/>
    <xsl:element name="NET_INTERFACE">
      <xsl:element name="type">
        <xsl:text>ETHERNET</xsl:text>
      </xsl:element>
      <xsl:element name="interfaceNbr">
        <xsl:value-of select="$InterfaceNumber"/>
      </xsl:element>
      <xsl:element name="connectedToNetlineNbr">0</xsl:element>
      <!-- new in 2.8.2 isUsed -->
      <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
        <xsl:element name="isUsed">ST_NO</xsl:element>
      </xsl:if>
      <xsl:element name="ETHERNET_PARAM">
        <xsl:element name="lineType">
          <xsl:text>CONNECTED_TO_LINK</xsl:text>
        </xsl:element>
        <xsl:element name="speedAndDuplex">
          <xsl:text>Auto</xsl:text>
        </xsl:element>
        <xsl:element name="flowControl">
          <xsl:text>Disabled</xsl:text>
        </xsl:element>
        <xsl:if test="user:IsVersionGreaterOrEqual($newversion,'2.8.2')">
          <xsl:element name="STP_PathCost">200000</xsl:element>
          <xsl:element name="STP_PortPriority">128</xsl:element>
          <xsl:element name="RSTP_LinkType">AUTO</xsl:element>
        </xsl:if>
      </xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- ADD CAN_PARAM 
  -->
  <xsl:template name="AddCANParam">
    <xsl:element name="CAN_PARAM">
      <xsl:element name="bitRate">41666</xsl:element>
      <xsl:element name="propagationSegment">11</xsl:element>
      <xsl:element name="phaseSegment1">2</xsl:element>
      <xsl:element name="phaseSegment2">2</xsl:element>
      <xsl:element name="synchronizationJumpWidth">2</xsl:element>
    </xsl:element>
  </xsl:template>
  <!-- *************************** Copies the PANEL-subtree, all elements are evaluated and can be handled  (converted..) by defining special templates
    -->
  <xsl:template name="CopyLocalConfig">
    <xsl:apply-templates select="/CONFIGURATION/PANEL_CLUSTER/NETWORK/PANEL"/>
  </xsl:template>
  <!-- *************************** Copy Customer Info Element
    -->
  <xsl:template name="CopyCustomerInfo">
    <xsl:apply-templates select="/CONFIGURATION/PANEL_CLUSTER/CUSTOMER_INFO"/>
  </xsl:template>
  <!-- *************************** Copy Support Info Element
    -->
  <xsl:template name="CopySupportInfo">
    <xsl:apply-templates select="/CONFIGURATION/PANEL_CLUSTER/SUPPORT_INFO"/>
  </xsl:template>
  <!--****************  SPECIAL PART modifications to certain nodes ***********************-->
  <!-- Panel/siNumber can be set to zero its no longer used in the panel SW -->
  <xsl:template match="PANEL/siNumber">
    <xsl:element name="siNumber">
      <xsl:text>0</xsl:text>
    </xsl:element>
  </xsl:template>
  <!-- repair bug in older configurations with siNumbers or subNumbers being empty -->
  <xsl:template match="siNumber | subNumber">
    <xsl:element name="{name()}">
      <xsl:choose>
        <xsl:when test=". = ''">
          <xsl:text>0</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- -->
  <msxsl:script language="javascript" implements-prefix="user">
	<![CDATA[
   function CutXmlExt(value)
   {
	   // cut ".xml" at the end
	   var textStrIn = value;
	   var textStr = textStrIn.slice(0, textStrIn.length-4);
	   return textStr;
   }
    ]]>
    </msxsl:script>
</xsl:stylesheet>
